<?php
require 'db.php';
?>
<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<title>User Dashboard - Turtle Tax</title>
<link rel="stylesheet" type="text/css" href="app-assets/vendors/css/vendors.min.css">
<link rel="stylesheet" type="text/css" href="app-assets/vendors/css/forms/wizard/bs-stepper.min.css">
<link rel="stylesheet" type="text/css" href="app-assets/vendors/css/forms/select/select2.min.css">
<link rel="stylesheet" type="text/css" href="app-assets/css/plugins/forms/form-validation.css">
<link rel="stylesheet" type="text/css" href="app-assets/css/plugins/forms/form-wizard.css">
<?php include 'styles.php';?>

<body class="vertical-layout vertical-menu-modern  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="">

    <!-- BEGIN: Header-->
    <?php include 'header.php' ?>
    
    
    <!-- END: Header-->


    <!-- BEGIN: Main Menu-->
    <?php include 'sidebar.php' ?>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">
            
            <div class="content-body">
                <!-- Horizontal Wizard -->
                <section class="horizontal-wizard">
                    <div class="bs-stepper horizontal-wizard-example">
                        <div class="bs-stepper-header" role="tablist">
                            <div class="step" data-target="#account-details" role="tab" id="personal-details-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">1</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Personal Details</span>
                                    </span>
                                </button>
                            </div>
                            
                            
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <div class="step" data-target="#address-step" role="tab" id="address-step-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">2</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Address Details</span>
                                        <span class="bs-stepper-subtitle">Add Address</span>
                                    </span>
                                </button>
                            </div>
                            
                        </div>
                        <div class="bs-stepper-content">
                            <div id="account-details" class="content" role="tabpanel" aria-labelledby="personal-details-trigger">
                                <div class="content-header">
                                    <h5 class="mb-0">Account Details</h5>
                                    <small class="text-muted">Enter Your Account Details.</small>
                                </div>
                                <form id="form-personal" method="post" action="">

                                    <div class="row">
                                        <div class="mb-1 col-md-12">
                                            <label class="form-label" for="fullname">Full Name</label>
                                            <input type="text" id="fullname" class="form-control" placeholder="Full Name (As Per PAN Card)" name="fullname" />
                                        </div>
                                        <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="dob">DOB</label>
                                                    <input type="date" id="dob" class="form-control" placeholder="DOB" name="dob" />
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="gender">Gender</label>
                                                    <select class="form-select" name="gender" id="gender">
                                                        <option disabled selected>Select Gender</option>
                                                        <option value="pnd">Prefer not to disclose</option>
                                                        <option value="male">Male</option>
                                                        <option value="female">Female</option>
                                                    </select>
                                                </div>
                                            </div>
                                             <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="fathername">Fathers Name (As Per PAN Card)</label>
                                                    <input type="text" id="fathername" class="form-control" name="fathername" placeholder="PAN Number" />
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-1">
                                                    <label class="form-label" for="maritalstatus">Marital Status</label>
                                                    <select class="form-select" name="maritalstatus" id="maritalstatus">
                                                        <option disabled selected>Select Marital Status</option>
                                                        <option value="married">Married</option>
                                                        <option value="unmarried">Unmarried</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="mb-1">
                                                    <label class="form-label" for="pan_no">PAN Number</label>
                                                    <input type="text" id="pan_no" minlength="10" maxlength="10" class="form-control" name="pan_no" placeholder="PAN Number" />
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="mb-1">
                                                    <label class="form-label" for="pancardfile">PAN Card</label>
                                                    <input type="file" accept=".png,.jpg,.jpeg,.pdf" data-rule-required="true" id="pancardfile" class="form-control" name="pancardfile" placeholder="Pan Card File" required />
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="mb-1">
                                                    <label class="form-label" for="aadhar_no">Aadhar Number</label>
                                                    <input type="text"  id="aadhar_no" minlength="12" maxlength="20" class="form-control" name="aadhar_no" placeholder="Aadhar Number" />
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <div class="mb-1">
                                                    <label class="form-label" for="aadharcardfile">Aadhar Card (Both Sides)</label>
                                                    <input type="file" accept=".png,.jpg,.jpeg,.pdf" id="aadharcardfile" class="form-control" name="aadharcardfile" placeholder="Aadhar card" required />
                                                </div>
                                            </div>
                                    </div>
                                    
                                </form>
                               
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-outline-secondary btn-prev" disabled>
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                    </button>
                                    <button class="btn btn-primary btn-next">
                                        <span class="align-middle d-sm-inline-block d-none">Next</span>
                                        <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div id="address-step" class="content" role="tabpanel" aria-labelledby="address-step-trigger">
                                <div class="content-header">
                                    <h5 class="mb-0">Address</h5>
                                    
                                </div>
                                <form id="form-address" method="post" action="">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="mb-1">>

                                                <label class="form-label" for="address">Full Address</label>
                                                <input type="text" id="address" class="form-control" placeholder=" Enter Address " name="address" required />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="road_street">Road/Street</label>
                                                <input type="text" id="road_street" class="form-control" placeholder="Road/Street" name="road_street" />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="premisename"> Premise Name</label>
                                                <input type="text" id="premisename" class="form-control" placeholder="premise Name" name="premisename" />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="pincode">Pincode</label>
                                                <input type="number" id="pincode" class="form-control" name="pincode" placeholder="Pincode" required />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="area_locality">Area/Locality</label>
                                                <input type="text" id="area_locality" class="form-control" name="area_locality" placeholder="Enter Area/Locality" />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="city">Town/City</label>
                                                <input type="text" id="city" class="form-control" name="city" placeholder="Enter Town/City" />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="mb-1">
                                                <label class="form-label" for="state">State</label>
                                                <input type="text" id="state" class="form-control" name="state" placeholder="Enter State Name" required />
                                            </div>
                                        </div>
                                        
                                        
                                       
                                    </div>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                    </button>
                                    <button class="btn btn-success btn-submit">Submit</button>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </section>
                <!-- /Horizontal Wizard -->
                <!-- Vertical Wizard -->
                
                <!-- /Modern Vertical Wizard -->
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
   
    <button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="app-assets/vendors/js/forms/wizard/bs-stepper.min.js"></script>
        
    <?php include 'scripts.php';?>
	<script src="app-assets/vendors/js/forms/select/select2.full.min.js"></script>
    <script src="app-assets/vendors/js/forms/validation/jquery.validate.min.js"></script>
    <script src="app-assets/js/scripts/forms/form-wizard.js"></script>

   
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <!-- END: Page JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })
    </script>
</body>
<!-- END: Body-->

</html>